plugin modifier Arnold_Light_Decay
name:~ARNOLD_LIGHT_FILTER_DECAY_NAME~
category:"Arnold"

classID:#(0xf00df10d,0x4001a10e)

extends:ArnoldLightFilterModifier replaceUI:true version:1
(
  local displayShape, registerChangeHandler -- forward decl
  local oldVal
  on postCreate do registerChangeHandler()
  on clone oldObj do registerChangeHandler()
  on postLoad do registerChangeHandler()  
  
  fn registerChangeHandler =
  (
    when parameters delegate changes handleAt:#redrawViews do
    (
      local newVal = delegate.viewportData
      if newVal != oldVal do (oldVal = newVal; displayShape())
    )
  )

  fn displayShape = 
  (  
	local out = ""
	local shape = "0"
	local coneAngle = "0.0"
	
	if (delegate.viewportData != undefined) then
	(
		local options = filterString delegate.viewportData "|"
		shape = options[2]
		coneAngle = options[3]
	)
	
	local ns = this.arnold_node_near_start
	local ne = this.arnold_node_near_end
	local fs = this.arnold_node_far_start
	local fe = this.arnold_node_far_end
	
	local outNS = "color:0.3,0.3,0.8|shape:"
	local outNE = "color:0.3,0.3,0.7|shape:"
	local outFS = "color:0.3,0.3,0.6|shape:"
	local outFE = "color:0.3,0.3,0.5|shape:"
	
	if (shape != "1" and shape != "6" and shape != "8") then
	(
		local sep = ","
		local mainSep = "|"
		if(shape != "2") then
		(		  
			start = 0
			limit = 28
			if (shape == "3" or shape == "4") then 
			(
				start = 7
				limit = 21
			)
			
			for i = start to limit do
			(
				a = i * 360.0 / 28.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [ns * sinA, 0.0, ns * cosA] as string
				outNE += [ne * sinA, 0.0, ne * cosA] as string
				outFS += [fs * sinA, 0.0, fs * cosA] as string
				outFE += [fe * sinA, 0.0, fe * cosA] as string
				if (i < limit) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
			
			outNS += mainSep + "shape:"
			outNE += mainSep + "shape:"
			outFS += mainSep + "shape:"
			outFE += mainSep + "shape:"
			
			for i = start to limit do
			(
				a = i * 360.0 / 28.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [0.0, ns * sinA, ns * cosA] as string
				outNE += [0.0, ne * sinA, ne * cosA] as string
				outFS += [0.0, fs * sinA, fs * cosA] as string
				outFE += [0.0, fe * sinA, fe * cosA] as string
				if (i < limit) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
			
			outNS += mainSep + "shape:"
			outNE += mainSep + "shape:"
			outFS += mainSep + "shape:"
			outFE += mainSep + "shape:"
			
			for i = 0 to 28 do
			(
				a = i * 360.0 / 28.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [ns * sinA, ns * cosA, 0.0] as string
				outNE += [ne * sinA, ne * cosA, 0.0] as string
				outFS += [fs * sinA, fs * cosA, 0.0] as string
				outFE += [fe * sinA, fe * cosA, 0.0] as string
				if (i < 28) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
		)
	
		if (shape == "2") then
		(
			local outNS = "color:0.3,0.3,0.8|shape:"
		
			cAngle = -1.0 * cos(coneAngle as float*0.5);
			sAngle = sin(coneAngle as float*0.5);
		
			for i = 0 to 28 do
			(
				a = i * 360.0 / 28.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [sAngle * ns * sinA, sAngle * ns * cosA, cAngle * ns] as string
				outNE += [sAngle * ne * sinA, sAngle * ne * cosA, cAngle * ne] as string
				outFS += [sAngle * fs * sinA, sAngle * fs * cosA, cAngle * fs] as string
				outFE += [sAngle * fe * sinA, sAngle * fe * cosA, cAngle * fe] as string
				if (i < 28) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
			
			outNS += mainSep + "shape:"
			outNE += mainSep + "shape:"
			outFS += mainSep + "shape:"
			outFE += mainSep + "shape:"
			
			for i = -7 to 7 do
			(
				a = i * coneAngle as float / 14.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [ns * sinA, 0.0, -1.0 * ns * cosA] as string
				outNE += [ne * sinA, 0.0, -1.0 * ne * cosA] as string
				outFS += [fs * sinA, 0.0, -1.0 * fs * cosA] as string
				outFE += [fe * sinA, 0.0, -1.0 * fe * cosA] as string
				if (i < 7) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
			
    		outNS += mainSep + "shape:"
			outNE += mainSep + "shape:"
			outFS += mainSep + "shape:"
			outFE += mainSep + "shape:"
			
			for i = -7 to 7 do
			(
				a = i * coneAngle as float / 14.0
				cosA = cos(a)
				sinA = sin(a)
				outNS += [0.0, ns * sinA, -1.0 * ns * cosA] as string
				outNE += [0.0, ne * sinA, -1.0 * ne * cosA] as string
				outFS += [0.0, fs * sinA, -1.0 * fs * cosA] as string
				outFE += [0.0, fe * sinA, -1.0 * fe * cosA] as string
				if (i < 7) then
				(
					outNS += sep
					outNE += sep
					outFS += sep
					outFE += sep
				)		
			)
			
		)
		
		if (this.arnold_node_use_near_atten == true and this.show_near_atten == true) then
		(	
			out += outNS + mainSep + outNE
		)

		if (this.arnold_node_use_far_atten == true and this.show_far_atten == true) then
		(	
			if (out != "") then out += mainSep
			out += outFS + mainSep + outFE
		)
	)
	
	delegate.viewportShape = out
  )
  
  fn handleNS =
  (
	if(this.arnold_node_near_start > this.arnold_node_near_end) then this.arnold_node_near_end = this.arnold_node_near_start + 0.01
	if(this.arnold_node_near_start > this.arnold_node_far_start) then this.arnold_node_far_start = this.arnold_node_near_start + 0.02
    displayShape()
  )
  
  fn handleNE =
  (
	if(this.arnold_node_near_end < this.arnold_node_near_start) then this.arnold_node_near_start = this.arnold_node_near_end - 0.01
	if(this.arnold_node_near_end > this.arnold_node_far_start) then this.arnold_node_far_start = this.arnold_node_near_end + 0.01
    displayShape()
  )  
  
  fn handleFS =
  (
	if(this.arnold_node_far_start > this.arnold_node_far_end) then this.arnold_node_far_end = this.arnold_node_far_start + 0.01
    if(this.arnold_node_far_start < this.arnold_node_near_end) then this.arnold_node_near_end = this.arnold_node_far_start - 0.01
    displayShape()
  )
  
  fn handleFE =
  (
	if(this.arnold_node_far_end < this.arnold_node_far_start) then this.arnold_node_far_start = this.arnold_node_far_end - 0.01
	if(this.arnold_node_far_end < this.arnold_node_near_end) then this.arnold_node_near_end = this.arnold_node_far_end - 0.02
    displayShape()
  )
  
  fn buildToolTip label param desc =
  (
	label + "\n" + desc + "\nParameter: " + param
  )
  
  local use_near_atten_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_USE_NEAR_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_USE_NEAR_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_USE_NEAR_TT_DESC~ 
  local show_near_atten_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_NEAR_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_NEAR_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_NEAR_TT_DESC~ 
  local near_start_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_START_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_START_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_START_TT_DESC~ 
  local near_end_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_END_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_END_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_END_TT_DESC~ 
  local use_far_atten_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_USE_FAR_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_USE_FAR_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_USE_FAR_TT_DESC~ 
  local show_far_atten_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_FAR_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_FAR_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_FAR_TT_DESC~ 
  local far_start_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_FAR_START_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_FAR_START_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_FAR_START_TT_DESC~ 
  local far_end_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_DECAY_FAR_END_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_DECAY_FAR_END_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_DECAY_FAR_END_TT_DESC~ 
  
  parameters main rollout:params
  (
    arnold_node type:#string default:"light_decay" 
	arnold_node_use_near_atten type:#boolean animatable:false ui:use_near_atten default:false  
	show_near_atten type:#boolean animatable:false ui:show_near_atten default:false  
	arnold_node_near_start type:#float animatable:true ui:near_start default:0.0   
	arnold_node_near_end type:#float animatable:true ui:near_end default:0.0   
	arnold_node_use_far_atten type:#boolean animatable:false ui:use_far_atten default:false
	show_far_atten type:#boolean animatable:false ui:show_far_atten default:false
	arnold_node_far_start type:#float animatable:true ui:far_start default:0.0   
	arnold_node_far_end type:#float animatable:true ui:far_end default:0.0    
	
	on arnold_node_use_near_atten set val do displayShape()
	on arnold_node_use_far_atten set val do displayShape()
	on show_near_atten set val do displayShape()
	on show_far_atten set val do displayShape()
	
	on arnold_node_near_start set val do handleNS()
	on arnold_node_near_end set val do handleNE()
	on arnold_node_far_start set val do handleFS()
	on arnold_node_far_end set val do handleFE()	
  )
  
  rollout params ~ARNOLD_LIGHT_FILTER_DECAY_ROLLOUT_NAME~
  (
  	group ~ARNOLD_LIGHT_FILTER_DECAY_WARNING~
	(
		label decay_gpu_warning ~ARNOLD_LIGHT_FILTER_DECAY_WARNING_TEXT~
	)
  	group ~ARNOLD_LIGHT_FILTER_DECAY_NEAR~
	(
	  checkbox use_near_atten ~ARNOLD_LIGHT_FILTER_DECAY_USE_NEAR~ tooltip:use_near_atten_tt
	  checkbox show_near_atten ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_NEAR~ tooltip:show_near_atten_tt
	  spinner near_start ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_START~ range:[0.0,1e9,0.0] scale:0.01 tooltip:near_start_tt
	  spinner near_end ~ARNOLD_LIGHT_FILTER_DECAY_NEAR_END~ range:[0.0,1e9,0.0] scale:0.01 tooltip:near_end_tt
	)
	group ~ARNOLD_LIGHT_FILTER_DECAY_FAR~
	(
	  checkbox use_far_atten ~ARNOLD_LIGHT_FILTER_DECAY_USE_FAR~ tooltip:use_far_atten_tt
	  checkbox show_far_atten ~ARNOLD_LIGHT_FILTER_DECAY_SHOW_FAR~ tooltip:show_far_atten_tt
	  spinner far_start ~ARNOLD_LIGHT_FILTER_DECAY_FAR_START~ range:[0.0,1e9,0.0] scale:0.01 tooltip:far_start_tt
	  spinner far_end ~ARNOLD_LIGHT_FILTER_DECAY_FAR_END~ range:[0.0,1e9,0.0] scale:0.01 tooltip:far_end_tt
	)
  )
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAdBygGEGTN/qWj8DkNs56Gr7mZf1LiigTi
-- Zdq0gMGW0mLchusHx13lhaRJ+zCwGaUByTtxzj5fkZrNrqXxsw6Iq1i4UbMRzGK8
-- fCOpxPCCQopWOSmOjG4GQkrwDSsCpVBJ2JkBAT52uaBVL2ziDbDz3fP8QqXZQoOh
-- irUcPmmwi0YYUTzTPIph9w9xULHSzfhjCLTKQORsGOQVegzVvy3idUe5RC+SP8Xh
-- p9aLNKhPXPMOi/Seze2A/E8MZXcQY+EU/wEIY6Q0yI+/pNZ+tb33uTBqUdnus/vh
-- TE6VtKaruQxJLUD0SxEy3W0Or/gv5MPquYGbpfn5vzqr+ug1lUJZ
-- -----END-SIGNATURE-----